//movement script

function PersonController(){
	
	this.inputProfiles = new Array();
	this.log = "init..."
	this.cancelCurrentCheck = false;
	}


PersonController.prototype.addInputProfile = function (name,profile){

	this.inputProfiles.push([name,profile,false,false]);

	}

PersonController.prototype.delInputProfile = function (name){

	var tmparr= new Array();
	for(var i=0;i<this.inputProfiles.length;i++){
		if(this.inputProfiles[i][0]!=name)tmparr.push(this.inputProfiles[i]);
		}
	
	this.inputProfiles.length=0;
	GarbageCollect();
	this.inputProfiles=tmparr;
	this.cancelCurrentCheck = true;

	}
	
PersonController.prototype.lockInputProfile = function (name,input,render){
	ClearKey();
	for(var i=0;i<this.inputProfiles.length;i++){
		if(this.inputProfiles[i][0]==name){
			if(input!=undefined)this.inputProfiles[i][2]=input;
			if(render!=undefined)this.inputProfiles[i][3]=render;
			
			}
		}

	}
	
PersonController.prototype.lockAllInputProfile = function (input,render){
	ClearKey();
	for(var i=0;i<this.inputProfiles.length;i++){
			if(input!=undefined)this.inputProfiles[i][2]=input;
			if(render!=undefined)this.inputProfiles[i][3]=render;
		}
	}	

PersonController.prototype.checkInput = function (){
	this.cancelCurrentCheck = false;
	if(IsAnyKeyPressed()){
		this.log="key pressed";
		for(var i=0;i<this.inputProfiles.length;i++){
			if(!this.inputProfiles[i][2]){
				this.inputProfiles[i][1].callActions();
				if(this.cancelCurrentCheck)return;
				}
			}
		}
	else{
		this.log="no key pressed";
		}
	for(var i=0;i<this.inputProfiles.length;i++){
			if(!this.inputProfiles[i][3])this.inputProfiles[i][1].callRenderActions();
			if(this.cancelCurrentCheck)return;
			}
	}

PersonController.prototype.resetProfiles = function (){
	
	for(var i=0;i<this.inputProfiles.length;i++){
			this.inputProfiles[i][1].reset();
		}

}

//////////////////////////////////////////

function InputProfile(){
	
	this.actions = new Array();
	this.args = new Array();
	this.renderActions = new Array();
	this.reset = function(){};
	
	}

InputProfile.prototype.callActions = function(){

	for(var i=0;i<this.actions.length;i++){
		if(IsKeyPressed(this.actions[i][0])){
			this.actions[i][1]();
			}
		}
	}
	
InputProfile.prototype.callRenderActions = function(){
	
	for(var i=0;i<this.renderActions.length;i++){
		this.renderActions[i][1]();
		}
	}
	
InputProfile.prototype.addAction = function (key,action){

	this.actions.push([key,action]);

	}
	
InputProfile.prototype.addRenderAction = function (name,action){

	this.renderActions.push([name,action]);

	}

InputProfile.prototype.delAction = function (key){

	var tmparr= new Array();
	
	for(var i=0;i<this.actions.length;i++){
		
			if(this.actions[i][0]!=key)tmparr.push(this.actions[i]);
			
		}
		
	this.actions.length=0;
	GarbageCollect();
	this.actions=tmparr;

	}

InputProfile.prototype.delRenderAction = function (name){

	var tmparr= new Array();
	
	for(var i=0;i<this.renderActions.length;i++){
		
			if(this.renderActions[i][0]!=name)tmparr.push(this.renderActions[i]);
			
		}
		
	this.renderActions.length=0;
	GarbageCollect();
	this.renderActions=tmparr;

	}

InputProfile.prototype.getAction = function (key){

	for(var i=0;i<this.actions.length;i++){
		
		if(this.actions[i][0]==key)return this.actions[i][1];
		
		}
	return function(){};
	}
	
InputProfile.prototype.reset = function (){};

//////////////////////////////////////////
//input profiles presets


function createStandardMovement(name,up,down,left,right,talk,cancel){
	RequireScript("Eventscript_CharacterAnimation.js");
	var profile= new InputProfile();
	
	profile.args.push([0,0]); 															//   laufvektor     [0]
	profile.args.push(1);     															//   beschleunigung [1]
	profile.args.push([1,1]);     															//   verzgerung x,y     [2]
	profile.args.push(1.5);     															//   max speed      [3]
	profile.args.push([GetPersonX(name),GetPersonY(name)]); //coords [4]
	profile.args.push(0) 																		//tired [5]
	
	
	profile.addAction(up,
		function(){
			if(IsKeyPressed(left)&&IsKeyPressed(up))QueuePersonCommand(name, COMMAND_FACE_NORTHWEST, true);
			else if(IsKeyPressed(right)&&IsKeyPressed(up))QueuePersonCommand(name, COMMAND_FACE_NORTHEAST, true);
			else {
				if(IsKeyPressed(up))QueuePersonCommand(name, COMMAND_FACE_NORTH, true);
				if(profile.args[0][0]>0){
					profile.args[0][0]-=profile.args[1];
					if(profile.args[0][0]<profile.args[1])profile.args[0][0]=0;
					}
				if(profile.args[0][0]<0){
					profile.args[0][0]+=profile.args[1];
					if(profile.args[0][0]>-profile.args[1])profile.args[0][0]=0;
					}
				if(!IsPersonObstructed(name,profile.args[4][0]+profile.args[0][0],profile.args[4][1]))profile.args[4][0]+=profile.args[0][0];
				else{
					profile.args[0][0]=0;
					}
				SetPersonX(name,profile.args[4][0]);
				}
			
			if(!IsKeyPressed(down)){	
				profile.args[0][1]-=profile.args[1];
				if(profile.args[0][1]<-profile.args[3]*profile.args[2][1])
					profile.args[0][1]=-profile.args[3]*profile.args[2][1];
				//if(IsKeyPressed(right)||IsKeyPressed(left))profile.args[0][1]=profile.args[0][1]*Math.cos(45);
				QueuePersonCommand(name, COMMAND_ANIMATE, true);
				if(!IsPersonObstructed(name,profile.args[4][0],profile.args[4][1]+profile.args[0][1]))profile.args[4][1]+=profile.args[0][1];
				else{
					while(!IsPersonObstructed(name,profile.args[4][0],profile.args[4][1]-1)&&profile.args[0][1]<0)profile.args[4][1]--;
					profile.args[0][1]=0;
					if(!IsKeyPressed(right)&&!IsKeyPressed(left)&&GetObstructingPerson(name,profile.args[4][0],profile.args[4][1]-1)==""){
						profile.args[4][0]=Math.round(profile.args[4][0]);
						for(var i=0;i<GetTileWidth()+1;i++){
							if(!IsPersonObstructed(name,profile.args[4][0]+i,profile.args[4][1]-1)){
								profile.args[0][0]+=profile.args[1];
								if(profile.args[0][0]>=i){
									profile.args[4][0]+=i;
									profile.args[4][1]--;
									SetPersonX(name,profile.args[4][0]);
									SetPersonY(name,profile.args[4][1]);
									}
								else
									profile.getAction(right)();
								break;
								}
							if(!IsPersonObstructed(name,profile.args[4][0]-i,profile.args[4][1]-1)){
								profile.args[0][0]-=profile.args[1];
								if(profile.args[0][0]<=-i){
									profile.args[4][0]-=i;
									profile.args[4][1]--;
									SetPersonX(name,profile.args[4][0]);
									SetPersonY(name,profile.args[4][1]);
									}
								else
									profile.getAction(left)();
								break;
								}
							}
						}
					}
				SetPersonY(name,profile.args[4][1]);
				}
			else{
				if(profile.args[0][1]>0){
					profile.args[0][1]-=profile.args[1];
					if(profile.args[0][1]<profile.args[1])profile.args[0][1]=0;
					}
				if(profile.args[0][1]<0){
					profile.args[0][1]+=profile.args[1];
					if(profile.args[0][1]>-profile.args[1])profile.args[0][1]=0;
					}
				if(profile.args[0][1]!=0){
					if(!IsPersonObstructed(name,profile.args[4][0],profile.args[4][1]+profile.args[0][1]))profile.args[4][1]+=profile.args[0][1];
					else{
						profile.args[0][1]=0;
						}
					}
				else profile.args[4][1]=GetPersonY(name);
				SetPersonY(name,profile.args[4][1]);
				}
			}
		);
		
	
	profile.addAction(down,
		function(){
			if(IsKeyPressed(left)&&IsKeyPressed(down))QueuePersonCommand(name, COMMAND_FACE_SOUTHWEST, true);
			else if(IsKeyPressed(right)&&IsKeyPressed(down))QueuePersonCommand(name, COMMAND_FACE_SOUTHEAST, true);
			else if(!IsKeyPressed(up)){
				if(IsKeyPressed(down))QueuePersonCommand(name, COMMAND_FACE_SOUTH, true);
				if(profile.args[0][0]>0){
					profile.args[0][0]-=profile.args[1];
					if(profile.args[0][0]<profile.args[1])profile.args[0][0]=0;
					}
				if(profile.args[0][0]<0){
					profile.args[0][0]+=profile.args[1];
					if(profile.args[0][0]>-profile.args[1])profile.args[0][0]=0;
					}
				if(!IsPersonObstructed(name,profile.args[4][0]+profile.args[0][0],profile.args[4][1]))profile.args[4][0]+=profile.args[0][0];
				else{
					profile.args[0][0]=0;
					}
				SetPersonX(name,profile.args[4][0]);
				}
			
			if(!IsKeyPressed(up)){	
				profile.args[0][1]+=profile.args[1];
				if(profile.args[0][1]>profile.args[3]*profile.args[2][1])
					profile.args[0][1]=profile.args[3]*profile.args[2][1];
				//if(IsKeyPressed(right)||IsKeyPressed(left))profile.args[0][1]=profile.args[0][1]*Math.cos(45);
				QueuePersonCommand(name, COMMAND_ANIMATE, true);
				if(!IsPersonObstructed(name,profile.args[4][0],profile.args[4][1]+profile.args[0][1]))profile.args[4][1]+=profile.args[0][1];
				else{
					while(!IsPersonObstructed(name,profile.args[4][0],profile.args[4][1]+1)&&profile.args[0][1]>0)profile.args[4][1]++;
					profile.args[0][1]=0;
					if(!IsKeyPressed(right)&&!IsKeyPressed(left)&&GetObstructingPerson(name,profile.args[4][0],profile.args[4][1]+1)==""){
						profile.args[4][0]=Math.round(profile.args[4][0]);
						for(var i=0;i<GetTileWidth()+1;i++){
							if(!IsPersonObstructed(name,profile.args[4][0]+i,profile.args[4][1]+1)){
								profile.args[0][0]+=profile.args[1];
								if(profile.args[0][0]>=i){
									profile.args[4][0]+=i;
									profile.args[4][1]++;
									SetPersonX(name,profile.args[4][0]);
									SetPersonY(name,profile.args[4][1]);
									}
								else
									profile.getAction(right)();
								break;
								}
							if(!IsPersonObstructed(name,profile.args[4][0]-i,profile.args[4][1]+1)){
								profile.args[0][0]-=profile.args[1];
								if(profile.args[0][0]<=-i){
									profile.args[4][0]-=i;
									profile.args[4][1]++;
									SetPersonX(name,profile.args[4][0]);
									SetPersonY(name,profile.args[4][1]);
									}
								else
									profile.getAction(left)();
								break;
								}
							}
						}
					profile.args[0][1]=0;
					}
				SetPersonY(name,profile.args[4][1]);
				}
			}
		);
		
	profile.addAction(left,
		function(){
			if(IsKeyPressed(up)&&IsKeyPressed(left))QueuePersonCommand(name, COMMAND_FACE_NORTHWEST, true);
			else if(IsKeyPressed(down)&&IsKeyPressed(left))QueuePersonCommand(name, COMMAND_FACE_SOUTHWEST, true);
			else {
				if(IsKeyPressed(left))QueuePersonCommand(name, COMMAND_FACE_WEST, true);
				if(profile.args[0][1]>0){
					profile.args[0][1]-=profile.args[1];
					if(profile.args[0][1]<profile.args[1])profile.args[0][1]=0;
					}
				if(profile.args[0][1]<0){
					profile.args[0][1]+=profile.args[1];
					if(profile.args[0][1]>-profile.args[1])profile.args[0][1]=0;
					}
				if(!IsPersonObstructed(name,profile.args[4][0],profile.args[4][1]+profile.args[0][1]))profile.args[4][1]+=profile.args[0][1];
				else{
					profile.args[0][1]=0;
					}
				SetPersonY(name,profile.args[4][1]);
				}
			if(!IsKeyPressed(right)){
				profile.args[0][0]-=profile.args[1];
				if(profile.args[0][0]<-profile.args[3]*profile.args[2][0])
					profile.args[0][0]=-profile.args[3]*profile.args[2][0];
				//if(IsKeyPressed(up)||IsKeyPressed(down))profile.args[0][0]=profile.args[0][0]*Math.cos(45);
				QueuePersonCommand(name, COMMAND_ANIMATE, true);
				if(!IsPersonObstructed(name,profile.args[4][0]+profile.args[0][0],profile.args[4][1]))profile.args[4][0]+=profile.args[0][0];
				else{
					while(!IsPersonObstructed(name,profile.args[4][0]-1,profile.args[4][1])&&profile.args[0][0]<0)profile.args[4][0]--;
					profile.args[0][0]=0;
					if(!IsKeyPressed(up)&&!IsKeyPressed(down)&&GetObstructingPerson(name,profile.args[4][0]-1,profile.args[4][1])==""){
						profile.args[4][1]=Math.round(profile.args[4][1]);
						for(var i=0;i<GetTileHeight()+1;i++){
							if(!IsPersonObstructed(name,profile.args[4][0]-1,profile.args[4][1]+i)){
								profile.args[0][1]+=profile.args[1];
								if(profile.args[0][1]>=i){
									profile.args[4][1]+=i;
									profile.args[4][0]--;
									SetPersonX(name,profile.args[4][0]);
									SetPersonY(name,profile.args[4][1]);
									}
								else
									profile.getAction(down)();
								break;
								}
							if(!IsPersonObstructed(name,profile.args[4][0]-1,profile.args[4][1]-i)){
								profile.args[0][1]-=profile.args[1];
								if(profile.args[0][1]<=-i){
									profile.args[4][1]-=i;
									profile.args[4][0]--;
									SetPersonX(name,profile.args[4][0]);
									SetPersonY(name,profile.args[4][1]);
									}
								else
									profile.getAction(up)();
								break;
								}
							}
						}
					}
				SetPersonX(name,profile.args[4][0]);
				}
			else{
				if(profile.args[0][0]>0){
					profile.args[0][0]-=profile.args[1];
					if(profile.args[0][0]<profile.args[1])profile.args[0][0]=0;
					}
				if(profile.args[0][0]<0){
					profile.args[0][0]+=profile.args[1];
					if(profile.args[0][0]>-profile.args[1])profile.args[0][0]=0;
					}
				if(profile.args[0][0]!=0){
					if(!IsPersonObstructed(name,profile.args[4][0]+profile.args[0][0],profile.args[4][1]))profile.args[4][0]+=profile.args[0][0];
					else{
					profile.args[0][0]=0;
						}
					}
				else profile.args[4][0]=GetPersonX(name);
				SetPersonX(name,profile.args[4][0]);
				}
			}
		);
		
	profile.addAction(right,
		function(){
			if(IsKeyPressed(up)&&IsKeyPressed(right))QueuePersonCommand(name, COMMAND_FACE_NORTHEAST, true);
			else if(IsKeyPressed(down)&&IsKeyPressed(right))QueuePersonCommand(name, COMMAND_FACE_SOUTHEAST, true);
			else if(!IsKeyPressed(left)){
				if(IsKeyPressed(right))QueuePersonCommand(name, COMMAND_FACE_EAST, true);
				if(profile.args[0][1]>0){
					profile.args[0][1]-=profile.args[1];
					if(profile.args[0][1]<profile.args[1])profile.args[0][1]=0;
					}
				if(profile.args[0][1]<0){
					profile.args[0][1]+=profile.args[1];
					if(profile.args[0][1]>-profile.args[1])profile.args[0][1]=0;
					}
				if(!IsPersonObstructed(name,profile.args[4][0],profile.args[4][1]+profile.args[0][1]))profile.args[4][1]+=profile.args[0][1];
				else{
					profile.args[0][1]=0;
					}
				SetPersonY(name,profile.args[4][1]);
				}
				
			if(!IsKeyPressed(left)){	
				profile.args[0][0]+=profile.args[1];
				if(profile.args[0][0]>profile.args[3]*profile.args[2][0])
					profile.args[0][0]=profile.args[3]*profile.args[2][0];
				//if(IsKeyPressed(up)||IsKeyPressed(down))profile.args[0][0]=profile.args[0][0]*Math.cos(45);
				QueuePersonCommand(name, COMMAND_ANIMATE, true);
				if(!IsPersonObstructed(name,profile.args[4][0]+profile.args[0][0],profile.args[4][1]))profile.args[4][0]+=profile.args[0][0];
				else{
					while(!IsPersonObstructed(name,profile.args[4][0]+1,profile.args[4][1])&&profile.args[0][0]>0)profile.args[4][0]++;
					profile.args[0][0]=0;
					if(!IsKeyPressed(up)&&!IsKeyPressed(down)&&GetObstructingPerson(name,profile.args[4][0]+1,profile.args[4][1])==""){
						profile.args[4][1]=Math.round(profile.args[4][1]);
						for(var i=0;i<GetTileHeight()+1;i++){
							if(!IsPersonObstructed(name,profile.args[4][0]+1,profile.args[4][1]+i)){
								profile.args[0][1]+=profile.args[1];
								if(profile.args[0][1]>=i){
									profile.args[4][1]+=i;
									profile.args[4][0]++;
									SetPersonX(name,profile.args[4][0]);
									SetPersonY(name,profile.args[4][1]);
									}
								else
									profile.getAction(down)();
								break;
								}
							if(!IsPersonObstructed(name,profile.args[4][0]+1,profile.args[4][1]-i)){
								profile.args[0][1]-=profile.args[1];
								if(profile.args[0][1]<=-i){
									profile.args[4][1]-=i;
									profile.args[4][0]++;
									SetPersonX(name,profile.args[4][0]);
									SetPersonY(name,profile.args[4][1]);
									}
								else
									profile.getAction(up)();
								break;
								}
							}
						}
					}
				SetPersonX(name,profile.args[4][0]);
				}
			}
		);
		
	profile.addAction(talk,
		function(){
			var dir=GetPersonDirection(name);
			var dx=0;
			var dy=0;
			switch(dir){
				case "north"    : dx = 0; dy =-1; break;
				case "northwest": dx =-1; dy =-1; break;
				case "west"     : dx =-1; dy = 0; break;
				case "southwest": dx =-1; dy = 1; break;
				case "south"    : dx = 0; dy = 1; break;
				case "southeast": dx = 1; dy = 1; break;
				case "east"     : dx = 1; dy = 0; break;
				case "northeast": dx = 1; dy =-1; break;
				}
			for(var i=0;i<GetTalkDistance();i++){
			
				if(GetObstructingPerson(name, GetPersonX(name)+dx*i,GetPersonY(name)+dy*i)!=""){
					personcontroller.lockAllInputProfile(true,true);
					SetDelayScript(0,"\
						if(GetObstructingPerson(\""+name+"\", GetPersonX(\""+name+"\")+"+(dx*i)+",GetPersonY(\""+name+"\")+"+(dy*i)+")!=\"\")CallPersonScript(GetObstructingPerson(\""+name+"\", GetPersonX(\""+name+"\")+"+(dx*i)+",GetPersonY(\""+name+"\")+"+(dy*i)+"),SCRIPT_ON_ACTIVATE_TALK);\
						personcontroller.lockAllInputProfile(false,false);\
						");
					g_lastTalker=name;
					//CallPersonScript(GetObstructingPerson(name, GetPersonX(name)+dx*i,GetPersonY(name)+dy*i),SCRIPT_ON_ACTIVATE_TALK);
					//ClearKey();
					//UpdateMapEngine();
					//RenderMap();
					return;
					}
				
				}
			}
		);
		
	
	profile.addRenderAction("stand",
		function(){
							
				if(!IsKeyPressed(up)&&!IsKeyPressed(down)&&!IsKeyPressed(left)&&!IsKeyPressed(right)){
					SetPersonFrame(name, 0);
				
					if(profile.args[0][1]>0){
						profile.args[0][1]-=profile.args[1];
						if(profile.args[0][1]<profile.args[1])profile.args[0][1]=0;
						}
					if(profile.args[0][1]<0){
						profile.args[0][1]+=profile.args[1];
						if(profile.args[0][1]>-profile.args[1])profile.args[0][1]=0;
						}
					if(profile.args[0][1]!=0){
						if(!IsPersonObstructed(name,profile.args[4][0],profile.args[4][1]+profile.args[0][1]))profile.args[4][1]+=profile.args[0][1];
						else{
							profile.args[0][1]=0;
							}
						}
					else profile.args[4][1]=GetPersonY(name);
					SetPersonY(name,profile.args[4][1]);
					
					if(profile.args[0][0]>0){
						profile.args[0][0]-=profile.args[1];
						if(profile.args[0][0]<profile.args[1])profile.args[0][0]=0;
						}
					if(profile.args[0][0]<0){
						profile.args[0][0]+=profile.args[1];
						if(profile.args[0][0]>-profile.args[1])profile.args[0][0]=0;
						}
					if(profile.args[0][0]!=0){
						if(!IsPersonObstructed(name,profile.args[4][0]+profile.args[0][0],profile.args[4][1]))profile.args[4][0]+=profile.args[0][0];
						else{
							profile.args[0][0]=0;
							}
						}
					else profile.args[4][0]=GetPersonX(name);
					SetPersonX(name,profile.args[4][0]);
					}
				/*
				if(!IsKeyPressed(KEY_C)){
					SetPersonAngle(name,0);
					}/**/
				if(!IsKeyPressed(btn_SPC)){
						
						if(profile.args[3]>1.5)profile.args[3]-=0.1;
						if(profile.args[5]>0){
							profile.args[5]--;
							if(profile.args[5]<100)CA_StopTiredFromRunning(name);
							}
					}
			}
		);
	profile.addAction(btn_SPC,
		function(){
				if(profile.args[5]>500){
					if(profile.args[3]>1.5)profile.args[3]-=0.1;
				}
				else{
					if(profile.args[3]<3)profile.args[3]+=0.1;
					profile.args[5]++;
					if(profile.args[5]==500)CA_StartTiredFromRunning(name);
					}
				
				
			}
		);
	/*RUMGESPIELT ^^
	profile.addAction(KEY_C,
		function(){
				SetPersonAngle(name,GetPersonAngle(name)+1);
			}
		);
	/**/
	profile.addAction(cancel,
		function(){
				SetDelayScript(0,"\
				personcontroller.lockAllInputProfile(true,undefined);\
				Spielmenu(true);\
				personcontroller.lockAllInputProfile(false,undefined);\
				");
			}
		);
	/*PERSONINFO
	profile.addRenderAction("PersonInfo",
		function(){
				Rectangle(Math.min(Math.max(MapToScreenX(GetPersonLayer(name),GetPersonX(name)),0),GetScreenWidth()),Math.min(Math.max(MapToScreenY(GetPersonLayer(name),GetPersonY(name)),0),GetScreenHeight()),200,100,CreateColor(0,0,0,180));
				GetSystemFont().drawText(Math.min(Math.max(MapToScreenX(GetPersonLayer(name),GetPersonX(name)),0),GetScreenWidth()),Math.min(Math.max(MapToScreenY(GetPersonLayer(name),GetPersonY(name)),0),GetScreenHeight()),name+": x="+GetPersonX(name)+"("+profile.args[4][0]+")"+" y="+GetPersonY(name)+"("+profile.args[4][1]+")");
				GetSystemFont().drawText(Math.min(Math.max(MapToScreenX(GetPersonLayer(name),GetPersonX(name)),0),GetScreenWidth()),Math.min(Math.max(MapToScreenY(GetPersonLayer(name),GetPersonY(name)),0),GetScreenHeight())+GetSystemFont().getHeight(),"glideX="+profile.args[0][0]+" glideY="+profile.args[0][1]);
				GetSystemFont().drawText(Math.min(Math.max(MapToScreenX(GetPersonLayer(name),GetPersonX(name)),0),GetScreenWidth()),Math.min(Math.max(MapToScreenY(GetPersonLayer(name),GetPersonY(name)),0),GetScreenHeight())+GetSystemFont().getHeight()*2,"layer: "+GetPersonLayer(name)+" dir: "+GetPersonDirection(name));
			}
		);
	/**/
	profile.addRenderAction("Ice",
		function(){
			if(GetPersonX(name)<GetLayerWidth(GetPersonLayer(name))*GetTileWidth()&&GetPersonY(name)<GetLayerHeight(GetPersonLayer(name))*GetTileWidth()&&GetPersonX(name)>=0&&GetPersonY(name)>=0){
				if(GetTileName(GetTile(Math.floor(GetPersonX(name)/GetTileWidth()),Math.floor(GetPersonY(name)/GetTileHeight()),GetPersonLayer(name)))=="TILE_ICE"){
					profile.args[1]=0.01;
					}
				else{
					profile.args[1]=1;
					}
				}
			}
		);
		
	profile.addRenderAction("Zones_Triggers",
		function(){
			if(AreZonesAt(GetPersonX(name),GetPersonY(name),GetPersonLayer(name))){
				personcontroller.lockAllInputProfile(true,true);
				SetDelayScript(0,"\
								\
								ExecuteZones(GetPersonX(\""+name+"\"),GetPersonY(\""+name+"\"),GetPersonLayer(\""+name+"\"));\
								personcontroller.lockAllInputProfile(false,false);\
								");
								//UpdateMapEngine();\
								//RenderMap();");
								//profile.args[4][0]=GetPersonX(name);
								//profile.args[4][1]=GetPersonY(name);
				}
			if(IsTriggerAt(GetPersonX(name),GetPersonY(name),GetPersonLayer(name))){
				
				personcontroller.lockAllInputProfile(true,true);
				SetDelayScript(0,"\
				\
				ExecuteTrigger(GetPersonX(\""+name+"\"),GetPersonY(\""+name+"\"),GetPersonLayer(\""+name+"\"));\
				personcontroller.lockAllInputProfile(false,false);\
				\
				");
				
				//profile.args[4][0]=GetPersonX(name);
				//profile.args[4][1]=GetPersonY(name);
				//profile.args[0][0]=0;
				//profile.args[0][1]=0;
				
				}
			
			if(GetObstructingPerson(name, GetPersonX(name)+1,GetPersonY(name))!=""){
				personcontroller.lockAllInputProfile(true,true);
				SetDelayScript(0,"\
				\
				if(GetObstructingPerson(\""+name+"\", GetPersonX(\""+name+"\")+1,GetPersonY(\""+name+"\"))!=\"\")CallPersonScript(GetObstructingPerson(\""+name+"\", GetPersonX(\""+name+"\")+1,GetPersonY(\""+name+"\")),SCRIPT_ON_ACTIVATE_TOUCH);\
				personcontroller.lockAllInputProfile(false,false);\
				\
				");
				
				}
			else if(GetObstructingPerson(name, GetPersonX(name)-1,GetPersonY(name))!=""){
				personcontroller.lockAllInputProfile(true,true);
				SetDelayScript(0,"\
				\
				if(GetObstructingPerson(\""+name+"\", GetPersonX(\""+name+"\")-1,GetPersonY(\""+name+"\"))!=\"\")CallPersonScript(GetObstructingPerson(\""+name+"\", GetPersonX(\""+name+"\")-1,GetPersonY(\""+name+"\")),SCRIPT_ON_ACTIVATE_TOUCH);\
				personcontroller.lockAllInputProfile(false,false);\
				\
				");
				}
			else if(GetObstructingPerson(name, GetPersonX(name),GetPersonY(name)+1)!=""){
				personcontroller.lockAllInputProfile(true,true);
				SetDelayScript(0,"\
				\
				if(GetObstructingPerson(\""+name+"\", GetPersonX(\""+name+"\"),GetPersonY(\""+name+"\")+1)!=\"\")CallPersonScript(GetObstructingPerson(\""+name+"\", GetPersonX(\""+name+"\"),GetPersonY(\""+name+"\")+1),SCRIPT_ON_ACTIVATE_TOUCH);\
				personcontroller.lockAllInputProfile(false,false);\
				\
				");
				}
			else if(GetObstructingPerson(name, GetPersonX(name),GetPersonY(name)-1)!=""){
				personcontroller.lockAllInputProfile(true,true);
				SetDelayScript(0,"\
				\
				if(GetObstructingPerson(\""+name+"\", GetPersonX(\""+name+"\"),GetPersonY(\""+name+"\")-1)!=\"\")CallPersonScript(GetObstructingPerson(\""+name+"\", GetPersonX(\""+name+"\"),GetPersonY(\""+name+"\")-1),SCRIPT_ON_ACTIVATE_TOUCH);\
				personcontroller.lockAllInputProfile(false,false);\
				\
				");
				}
			}
		);
	
	profile.reset = function(){
		
			profile.args[4][0]=GetPersonX(name);
			profile.args[4][1]=GetPersonY(name);
			profile.args[0][0]=0;
			profile.args[0][1]=0;		
		
		}
	
	return profile;

	}
/*--------------------------------------------------*/

function createTriggeredMovement(name,walkvec,step){
	
	var profile= new InputProfile();
	profile.args.push([GetPersonX(name),GetPersonY(name)]); //[0]actpos
	
	profile.addRenderAction(
		"check_triggers",function(){
			profile.args[0]=[GetPersonX(name),GetPersonY(name)];
			/*DEBUG*
				font.drawText(100,100,);
				
				/**/
			if(walkvec[0]!=0){
				var tmpstep = step
				
				if(tmpstep>Math.abs(walkvec[0]))tmpstep=walkvec[0];
				
				if(walkvec[0]<0)tmpstep = Math.abs(step)*-1
				else tmpstep = Math.abs(step);
				
										
				if(!IsPersonObstructed(name,profile.args[0][0]+tmpstep,profile.args[0][1])){
					
					profile.args[0][0]+=tmpstep;
					walkvec[0]-=tmpstep;
					
					}
				}
			if(walkvec[1]!=0){
				var tmpstep = step
				
				if(tmpstep>Math.abs(walkvec[1]))tmpstep=walkvec[1];
				
				if(walkvec[1]<0)tmpstep = Math.abs(step)*-1
				else tmpstep = Math.abs(step);
				
										
				if(!IsPersonObstructed(name,profile.args[0][0],profile.args[0][1]+tmpstep)){
					
					profile.args[0][1]+=tmpstep;
					walkvec[1]-=tmpstep;
					
					}
				}
			}
		);
	
	profile.addRenderAction(
		"move_walkvec",function(){
			
			QueuePersonCommand(name,COMMAND_ANIMATE,true);
			SetPersonX(name,profile.args[0][0]);
			SetPersonY(name,profile.args[0][1]);
			
		}
	);
	return profile;
}
/*--------------------------------------------------*/
///////////////////////////////////////////////////////////////